"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isBreakingChange = void 0;
const tslib_1 = require("tslib");
const semver_1 = tslib_1.__importDefault(require("semver"));
function isBreakingChange(currentVersion, nextVersion) {
    const releaseType = semver_1.default.diff(currentVersion, nextVersion);
    let breaking;
    if (releaseType === 'major') {
        // self-evidently
        breaking = true;
    }
    else if (releaseType === 'minor') {
        // 0.1.9 => 0.2.0 is breaking
        breaking = semver_1.default.lt(currentVersion, '1.0.0');
    }
    else if (releaseType === 'patch') {
        // 0.0.1 => 0.0.2 is breaking(?)
        breaking = semver_1.default.lt(currentVersion, '0.1.0');
    }
    else {
        // versions are equal, or any prerelease
        breaking = false;
    }
    return breaking;
}
exports.isBreakingChange = isBreakingChange;
//# sourceMappingURL=is-breaking-change.js.map