"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.countLeftRight = exports.updateRemote = exports.isBehindUpstream = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
function isBehindUpstream(gitRemote, branch, opts, dryRun = false) {
    npmlog_1.default.silly('isBehindUpstream', '');
    updateRemote(opts, dryRun);
    const remoteBranch = `${gitRemote}/${branch}`;
    const [behind, ahead] = countLeftRight(`${remoteBranch}...${branch}`, opts, dryRun);
    npmlog_1.default.silly('isBehindUpstream', `${branch} is behind ${remoteBranch} by ${behind} commit(s) and ahead by ${ahead}`);
    return Boolean(behind);
}
exports.isBehindUpstream = isBehindUpstream;
function updateRemote(opts, dryRun = false) {
    // git fetch, but for everything
    (0, core_1.execSync)('git', ['remote', 'update'], opts, dryRun);
}
exports.updateRemote = updateRemote;
function countLeftRight(symmetricDifference, opts, dryRun = false) {
    const stdout = (0, core_1.execSync)('git', ['rev-list', '--left-right', '--count', symmetricDifference], opts, dryRun);
    return stdout.split('\t').map((val) => parseInt(val, 10));
}
exports.countLeftRight = countLeftRight;
//# sourceMappingURL=is-behind-upstream.js.map