"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.isAnythingCommitted = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
function isAnythingCommitted(opts, dryRun = false) {
    npmlog_1.default.silly('isAnythingCommitted', '');
    let anyCommits = (0, core_1.execSync)('git', ['rev-list', '--count', '--all', '--max-count=1'], opts, dryRun);
    if (dryRun) {
        anyCommits = '1';
    }
    npmlog_1.default.verbose('isAnythingCommitted', anyCommits);
    return Boolean(parseInt(anyCommits, 10));
}
exports.isAnythingCommitted = isAnythingCommitted;
//# sourceMappingURL=is-anything-committed.js.map