"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gitTag = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
/**
 * @param {string} tag
 * @param {{ forceGitTag: boolean; signGitTag: boolean; }} gitOpts
 * @param {import('@lerna/child-process').ExecOpts} opts
 */
function gitTag(tag, { forceGitTag, signGitTag }, opts, command = 'git tag %s -m %s', dryRun = false) {
    npmlog_1.default.silly('gitTag', tag, command);
    const [cmd, ...args] = command.split(' ');
    const interpolatedArgs = args.map((arg) => arg.replace(/%s/, tag));
    if (forceGitTag) {
        interpolatedArgs.push('--force');
    }
    if (signGitTag) {
        interpolatedArgs.push('--sign');
    }
    npmlog_1.default.verbose(cmd, interpolatedArgs.toString());
    return (0, core_1.exec)(cmd, interpolatedArgs, opts, dryRun);
}
exports.gitTag = gitTag;
//# sourceMappingURL=git-tag.js.map