"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gitCommit = void 0;
const tslib_1 = require("tslib");
const os_1 = require("os");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
const utils_1 = require("../utils");
/**
 * @param {string} message
 * @param {{ amend: boolean; commitHooks: boolean; signGitCommit: boolean; }} gitOpts
 * @param {import('@lerna/child-process').ExecOpts} opts
 */
function gitCommit(message, { amend, commitHooks, signGitCommit, signoffGitCommit }, opts, dryRun = false) {
    npmlog_1.default.silly('gitCommit', message);
    const args = ['commit'];
    if (commitHooks === false) {
        args.push('--no-verify');
    }
    if (signGitCommit) {
        args.push('--gpg-sign');
    }
    if (signoffGitCommit) {
        args.push('--signoff');
    }
    if (amend) {
        args.push('--amend', '--no-edit');
    }
    else if (message.indexOf(os_1.EOL) > -1) {
        // Use tempfile to allow multi\nline strings.
        args.push('-F', utils_1.tempWrite.sync(message, 'lerna-commit.txt'));
    }
    else {
        args.push('-m', message);
    }
    npmlog_1.default.verbose('git', args.join(' '));
    return (0, core_1.exec)('git', args, opts, dryRun);
}
exports.gitCommit = gitCommit;
//# sourceMappingURL=git-commit.js.map