"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gitAdd = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const path_1 = tslib_1.__importDefault(require("path"));
const slash_1 = tslib_1.__importDefault(require("slash"));
const core_1 = require("@lerna-lite/core");
/**
 * @param {string[]} changedFiles
 * @param {{ granularPathspec: boolean; }} gitOpts
 * @param {import('@lerna/child-process').ExecOpts} execOpts
 */
function gitAdd(changedFiles, gitOpts, execOpts, dryRun = false) {
    // granular pathspecs should be relative to the git root, but that isn't necessarily where lerna-lite lives
    const files = gitOpts.granularPathspec
        ? changedFiles.map((file) => (0, slash_1.default)(path_1.default.relative(execOpts.cwd, path_1.default.resolve(execOpts.cwd, file))))
        : '.';
    npmlog_1.default.silly('gitAdd', files.toString());
    return (0, core_1.exec)('git', ['add', '--', ...files], execOpts, dryRun);
}
exports.gitAdd = gitAdd;
//# sourceMappingURL=git-add.js.map