"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentBranch = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
function getCurrentBranch(opts, dryRun = false) {
    npmlog_1.default.silly('currentBranch', '');
    const branch = (0, core_1.execSync)('git', ['rev-parse', '--abbrev-ref', 'HEAD'], opts, dryRun);
    npmlog_1.default.verbose('currentBranch', branch);
    return dryRun ? 'main' : branch;
}
exports.getCurrentBranch = getCurrentBranch;
//# sourceMappingURL=get-current-branch.js.map