import { GitCreateReleaseClientOutput, ReleaseClient, ReleaseCommandProps, ReleaseOptions } from '../models';
export declare function createReleaseClient(type: 'github' | 'gitlab'): GitCreateReleaseClientOutput;
/**
 * @param {ReturnType<typeof createReleaseClient>} client
 * @param {{ tags: string[]; releaseNotes: { name: string; notes: string; }[] }} commandProps
 * @param {{ gitRemote: string; execOpts: import('@lerna/child-process').ExecOpts }} opts
 */
export declare function createRelease(client: ReleaseClient, { tags, releaseNotes }: ReleaseCommandProps, { gitRemote, execOpts }: ReleaseOptions, dryRun?: boolean): Promise<(void | {
    ok: boolean;
    status: string;
    statusText: string;
})[]>;
