"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createGitLabClient = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const GitLabClient_1 = require("./GitLabClient");
function OcktokitAdapter(client) {
    return { repos: { createRelease: client.createRelease.bind(client) } };
}
function createGitLabClient() {
    const { GL_API_URL, GL_TOKEN } = process.env;
    npmlog_1.default.silly('Creating a GitLab client...', '');
    if (!GL_TOKEN) {
        throw new Error('A GL_TOKEN environment variable is required.');
    }
    const client = new GitLabClient_1.GitLabClient(GL_TOKEN, GL_API_URL);
    return OcktokitAdapter(client);
}
exports.createGitLabClient = createGitLabClient;
//# sourceMappingURL=gitlab-client.js.map