"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseGitRepo = exports.createGitHubClient = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@lerna-lite/core");
const rest_1 = require("@octokit/rest");
const git_url_parse_1 = tslib_1.__importDefault(require("git-url-parse"));
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
function createGitHubClient() {
    npmlog_1.default.silly('createGitHubClient', '');
    const { GH_TOKEN, GHE_API_URL, GHE_VERSION } = process.env;
    const options = {};
    if (GH_TOKEN) {
        options.auth = `token ${GH_TOKEN}`;
    }
    if (GHE_VERSION) {
        // eslint-disable-next-line
        rest_1.Octokit.plugin(require(`@octokit/plugin-enterprise-rest/ghe-${GHE_VERSION}`));
    }
    if (GHE_API_URL) {
        options.baseUrl = GHE_API_URL;
    }
    return new rest_1.Octokit(options);
}
exports.createGitHubClient = createGitHubClient;
function parseGitRepo(remote = 'origin', opts) {
    npmlog_1.default.silly('parseGitRepo', '');
    const args = ['config', '--get', `remote.${remote}.url`];
    npmlog_1.default.verbose('git', args.join(' '));
    const url = (0, core_1.execSync)('git', args, opts);
    if (!url) {
        throw new Error(`Git remote URL could not be found using "${remote}".`);
    }
    return (0, git_url_parse_1.default)(url);
}
exports.parseGitRepo = parseGitRepo;
//# sourceMappingURL=github-client.js.map