"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitLabClient = void 0;
const tslib_1 = require("tslib");
const node_fetch_1 = tslib_1.__importDefault(require("node-fetch"));
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const path_1 = tslib_1.__importDefault(require("path"));
class GitLabClient {
    constructor(token, baseUrl = 'https://gitlab.com/api/v4') {
        this.baseUrl = baseUrl;
        this.token = token;
    }
    createRelease({ owner, repo, name, tag_name: tagName, body }) {
        const releasesUrl = this.releasesUrl(owner, repo, 'releases');
        npmlog_1.default.silly('Requesting GitLab releases', releasesUrl);
        return (0, node_fetch_1.default)(releasesUrl, {
            method: 'post',
            body: JSON.stringify({ name, tag_name: tagName, description: body }),
            headers: {
                'PRIVATE-TOKEN': this.token,
                'Content-Type': 'application/json',
            },
        }).then(({ ok, status, statusText }) => {
            if (!ok) {
                npmlog_1.default.error('gitlab', `Failed to create release\nRequest returned ${status} ${statusText}`);
            }
            else {
                npmlog_1.default.silly('gitlab', 'Created release successfully.');
            }
        });
    }
    releasesUrl(namespace, project, releaseType = 'releases') {
        return new URL(`${this.baseUrl}/${path_1.default.join('projects', encodeURIComponent(`${namespace}/${project}`), releaseType)}`).toString();
    }
}
exports.GitLabClient = GitLabClient;
//# sourceMappingURL=GitLabClient.js.map