import { Context, GitRawCommitsOptions } from 'conventional-changelog-core';
import { Options as WriterOptions } from 'conventional-changelog-writer';
import { Commit } from 'conventional-commits-parser';
import { ChangelogConfig, RemoteCommit } from '../models';
/**
 * Change the changelog config, we need to update the default format to include commit author name/email,
 * Add a `format` to the `conventional-changelog-core` of `gitRawCommitsOpts` will make it available in the commit template
 * https://github.com/conventional-changelog/conventional-changelog/blob/master/packages/git-raw-commits/index.js#L27
 * then no matter which changelog preset is loaded, we'll append the git author name to the commit template
 * ie:: **deps:** update all non-major dependencies ([ed1db35](https://github.com/.../ed1db35)) (Renovate Bot)
 * @param {ChangelogConfig} config
 * @param {GitRawCommitsOptions} gitRawCommitsOpts
 * @param {WriterOptions} writerOpts
 * @param {string | boolean} [commitCustomFormat]
 */
export declare function setConfigChangelogCommitGitAuthor(config: ChangelogConfig, gitRawCommitsOpts: GitRawCommitsOptions, writerOpts: WriterOptions, commitCustomFormat?: string | boolean): void;
/**
 * Change the changelog config, we need to update the default format to include remote client login name.
 * We also need to extend the transform function and add remote client login (GitHub),
 * and finally no matter which changelog preset is loaded, we'll append the client login to the commit template
 * ie:: **deps:** update all non-major dependencies ([ed1db35](https://github.com/.../ed1db35)) (@renovate-bot)
 * @param {ChangelogConfig} config
 * @param {GitRawCommitsOptions} gitRawCommitsOpts
 * @param {WriterOptions} writerOpts
 * @param {RemoteCommit[]} commitsSinceLastRelease
 * @param {string | boolean} [commitCustomFormat]
 */
export declare function setConfigChangelogCommitClientLogin(config: ChangelogConfig, gitRawCommitsOpts: GitRawCommitsOptions, writerOpts: WriterOptions, commitsSinceLastRelease: RemoteCommit[], commitCustomFormat?: string | boolean): void;
/**
 * Extend the writerOpts transform function from whichever preset config is currently loaded
 * We will execute the original writerOpts transform function, then from it we'll add extra properties to the commit object
 * @param {Transform} originalTransform
 * @param {RemoteCommit[]} commitsSinceLastRelease
 * @param {Commit} commit
 * @param {Context} context
 * @returns
 */
export declare function writerOptsTransform(originalTransform: (cmt: Commit, ctx: Context) => Commit, commitsSinceLastRelease: RemoteCommit[], commit: Commit, context: Context): Commit<string | number | symbol>;
