"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.readExistingChangelog = void 0;
const tslib_1 = require("tslib");
const fs_extra_1 = tslib_1.__importDefault(require("fs-extra"));
const path_1 = tslib_1.__importDefault(require("path"));
const constants_1 = require("./constants");
/**
 * Read the existing changelog, if it exists.
 * @param {import("@lerna/package").Package} pkg
 * @returns {Promise<[string, string]>} A tuple of changelog location and contents
 */
async function readExistingChangelog(pkg) {
    const changelogFileLoc = path_1.default.join(pkg.location, 'CHANGELOG.md');
    let chain = Promise.resolve();
    // catch allows missing file to pass without breaking chain
    chain = chain.then(() => fs_extra_1.default.readFile(changelogFileLoc, 'utf8').catch(() => ''));
    chain = chain.then((changelogContents) => {
        // Remove the header if it exists, thus starting at the first entry.
        const headerIndex = changelogContents.indexOf(constants_1.COMMIT_GUIDELINE);
        if (headerIndex !== -1) {
            return changelogContents.substring(headerIndex + constants_1.COMMIT_GUIDELINE.length + constants_1.BLANK_LINE.length);
        }
        return changelogContents;
    });
    // consumer expects resolved tuple
    chain = chain.then((changelogContents) => [changelogFileLoc, changelogContents]);
    return chain;
}
exports.readExistingChangelog = readExistingChangelog;
//# sourceMappingURL=read-existing-changelog.js.map