"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.makeBumpOnlyFilter = void 0;
const constants_1 = require("./constants");
/**
 * @param {import("@lerna/package").Package} pkg
 * @return {(entry: string) => string}
 */
function makeBumpOnlyFilter(pkg) {
    return (newEntry) => {
        // When force publishing, it is possible that there will be no actual changes, only a version bump.
        if (!newEntry.split('\n').some((line) => line.startsWith('*'))) {
            // Add a note to indicate that only a version bump has occurred.
            // TODO: actually list the dependencies that were bumped
            const message = `**Note:** Version bump only for package ${pkg.name}`;
            // the extra blank lines preserve the whitespace delimiting releases
            return [newEntry.trim(), message, constants_1.BLANK_LINE].join(constants_1.BLANK_LINE);
        }
        return newEntry;
    };
}
exports.makeBumpOnlyFilter = makeBumpOnlyFilter;
//# sourceMappingURL=make-bump-only-filter.js.map