import { ExecOpts } from '@lerna-lite/core';
import { RemoteCommit } from '../models';
/**
 * Get all commits from GitHub remote repository, using GitHub Graphql API, by providing a date to query from
 * https://docs.github.com/en/graphql/reference/objects#repository
 * @param {RemoteClientType} client
 * @param {String} gitRemote
 * @param {String} branchName
 * @param {ExecOpts} execOpts
 * @returns {Promise<RemoteCommit[]>}
 */
export declare function getGithubCommits(gitRemote: string, branchName: string, sinceDate: string, execOpts?: ExecOpts): Promise<RemoteCommit[]>;
