import { ExecOpts, RemoteClientType } from '@lerna-lite/core';
import { RemoteCommit } from '../models';
/**
 * From the current branch, find all commits since the last tag release.
 * The output will be an array which include every commit short hash & user login
 * @param {RemoteClientType} client
 * @param {String} gitRemote
 * @param {String} branchName
 * @param {Boolean} [isIndependent]
 * @param {ExecOpts} [execOpts]
 * @returns {Promise<RemoteCommit[]>}
 */
export declare function getCommitsSinceLastRelease(client: RemoteClientType, gitRemote: string, branchName: string, isIndependent?: boolean, execOpts?: ExecOpts): Promise<RemoteCommit[]>;
/**
 * Find the oldest commit details since the last release tag or else if not tag exists then return first commit info
 * @param {ExecOpts} [execOpts]
 * @param {Boolean} [includeMergedTags]
 * @param {Boolean} [isIndependent]
 * @returns {*} - oldest commit detail (hash, date)
 */
export declare function getOldestCommitSinceLastTag(execOpts?: ExecOpts, isIndependent?: boolean, includeMergedTags?: boolean): {
    commitHash: string;
    commitDate: string;
};
