"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.applyBuildMetadata = void 0;
const core_1 = require("@lerna-lite/core");
const BUILD_METADATA_REGEX = /^[0-9a-zA-Z-]+(\.[0-9a-zA-Z-]+)*$/;
/**
 * Append build metadata to version.
 * @param {string} version
 * @param {string} buildMetadata
 */
function applyBuildMetadata(version, buildMetadata) {
    version = version || '';
    if (!buildMetadata) {
        return version;
    }
    if (isValidBuildMetadata(buildMetadata)) {
        return `${version}+${buildMetadata}`;
    }
    throw new core_1.ValidationError('EBUILDMETADATA', 'Build metadata does not satisfy SemVer specification.');
}
exports.applyBuildMetadata = applyBuildMetadata;
/**
 * Validate build metadata against SemVer specification.
 * @see https://semver.org/#spec-item-10
 *
 * @param {string} buildMetadata
 */
function isValidBuildMetadata(buildMetadata) {
    return BUILD_METADATA_REGEX.test(buildMetadata);
}
//# sourceMappingURL=apply-build-metadata.js.map