"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
// https://github.com/conventional-changelog/conventional-changelog/blob/b516084ef6a725197f148236c0ddbfae7ffe3e6f/packages/conventional-changelog-angular/conventional-recommended-bump.js
// (conventional-changelog-angular/conventional-recommended-bump.js, etc)
const parser_opts_1 = tslib_1.__importDefault(require("./parser-opts"));
const writer_opts_1 = tslib_1.__importDefault(require("./writer-opts"));
const what_bump_1 = tslib_1.__importDefault(require("./what-bump"));
// https://github.com/conventional-changelog/conventional-changelog/blob/943542f3b2342bb5933d84847fb19b727c607df0/packages/conventional-changelog-ember/index.js#L10
module.exports = presetOpts;
function presetOpts(param) {
    if (typeof param !== 'function') {
        return Promise.resolve(Object.assign(param, {
            parserOpts: parser_opts_1.default,
            writerOpts: writer_opts_1.default,
            whatBump: what_bump_1.default,
        }));
    }
    process.nextTick(param, null, {
        parserOpts: parser_opts_1.default,
        writerOpts: writer_opts_1.default,
        whatBump: what_bump_1.default,
    });
}
//# sourceMappingURL=config-builder-preset.js.map