import { Command, CommandType, Package, ProjectConfig, RunCommandOption } from '@lerna-lite/core';
import { FilterOptions } from '@lerna-lite/filter-packages';
import { ScriptStreamingOption } from './models';
export declare function factory(argv: RunCommandOption): RunCommand;
export declare class RunCommand extends Command<RunCommandOption & FilterOptions> {
    /** command name */
    name: CommandType;
    args: string[];
    bail: boolean;
    count?: number;
    packagePlural?: 'package' | 'packages';
    joinedCommand?: string;
    prefix: boolean;
    npmClient: string;
    packagesWithScript: Package[];
    script: string;
    get requiresGit(): boolean;
    constructor(argv: RunCommandOption | ProjectConfig);
    initialize(): Promise<false | undefined>;
    execute(): Promise<void>;
    getOpts(pkg: Package): ScriptStreamingOption;
    getRunner(): (pkg: Package) => Promise<any>;
    runScriptInPackagesTopological(): Promise<any>;
    /** Nx requires quotes around script names of the form script:name*/
    escapeScriptNameQuotes(scriptName: string): string;
    runScriptsUsingNx(): Promise<any>;
    prepNxOptions(): Promise<{
        targetDependencies: {
            [x: string]: {
                projects: string;
                target: string;
            }[];
        };
        options: {
            outputStyle: string;
            /**
             * To match lerna's own behavior (via pMap's default concurrency), we set parallel to a very large number if
             * the flag has been set (we can't use Infinity because that would cause issues with the task runner).
             */
            parallel: number;
            nxBail: boolean;
            nxIgnoreCycles: boolean;
            skipNxCache: boolean | undefined;
            verbose: boolean | undefined;
            __overrides__: string[];
        };
        extraOptions: {
            excludeTaskDependencies: boolean;
            loadDotEnvFiles: boolean;
        };
    }>;
    runScriptInPackagesParallel(): Promise<any[]>;
    runScriptInPackagesLexical(): Promise<any[]>;
    runScriptInPackageStreaming(pkg: Package): Promise<any>;
    runScriptInPackageCapturing(pkg: Package): Promise<any>;
    configureNxOutput(): Promise<unknown>;
    dryRunScript(scriptName: string, pkgName: string): Promise<any>;
}
