"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.npmRunScriptStreaming = exports.npmRunScript = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
const get_npm_exec_opts_1 = require("./get-npm-exec-opts");
function npmRunScript(script, { args, npmClient, pkg, reject = true }, dryRun = false) {
    npmlog_1.default.silly('npmRunScript', script, args, pkg.name);
    const argv = ['run', script, ...args];
    const opts = makeOpts(pkg, reject);
    return (0, core_1.exec)(npmClient, argv, opts, dryRun);
}
exports.npmRunScript = npmRunScript;
function npmRunScriptStreaming(script, { args, npmClient, pkg, prefix, reject = true }, dryRun = false) {
    npmlog_1.default.silly('npmRunScriptStreaming', JSON.stringify([script, args, pkg.name]));
    const argv = ['run', script, ...args];
    const opts = makeOpts(pkg, reject);
    return (0, core_1.spawnStreaming)(npmClient, argv, opts, prefix && pkg.name, dryRun);
}
exports.npmRunScriptStreaming = npmRunScriptStreaming;
function makeOpts(pkg, reject) {
    return Object.assign((0, get_npm_exec_opts_1.getNpmExecOpts)(pkg), {
        windowsHide: false,
        reject,
    });
}
//# sourceMappingURL=npm-run-script.js.map