"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getNpmExecOpts = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
function getNpmExecOpts(pkg) {
    // execa automatically extends process.env
    const env = {
        LERNA_PACKAGE_NAME: pkg.name,
    };
    npmlog_1.default.silly('getNpmExecOpts', pkg.location);
    return {
        cwd: pkg.location,
        env,
        pkg,
    };
}
exports.getNpmExecOpts = getNpmExecOpts;
//# sourceMappingURL=get-npm-exec-opts.js.map