import { OneTimePasswordCache } from '@lerna-lite/version';
import { Command, CommandType, Conf, Package, PackageGraphNode, ProjectConfig, PublishCommandOption } from '@lerna-lite/core';
export declare function factory(argv: PublishCommandOption): PublishCommand;
export declare class PublishCommand extends Command<PublishCommandOption> {
    /** command name */
    name: CommandType;
    conf: Conf & {
        snapshot?: any;
    };
    otpCache: OneTimePasswordCache;
    gitReset: boolean;
    savePrefix: string;
    tagPrefix: string;
    hasRootedLeaf: boolean;
    npmSession: string;
    packagesToPublish: Package[];
    publishedPackages: Package[];
    packagesToBeLicensed?: Package[];
    runPackageLifecycle: (pkg: Package, stage: string) => Promise<void>;
    runRootLifecycle: (stage: string) => Promise<void> | void;
    verifyAccess?: boolean;
    toposort: boolean;
    twoFactorAuthRequired: boolean;
    updates: PackageGraphNode[];
    updatesVersions?: Map<string, any>;
    get otherCommandConfigs(): string[];
    get requiresGit(): boolean;
    constructor(argv: PublishCommandOption | ProjectConfig);
    configureProperties(): void;
    get userAgent(): string;
    initialize(): Promise<boolean>;
    execute(): Promise<void>;
    verifyWorkingTreeClean(): Promise<void>;
    detectFromGit(): Promise<{
        updates: Package[];
        updatesVersions: string[][];
        needsConfirmation: boolean;
    }>;
    detectFromPackage(): Promise<{
        updates: any;
        updatesVersions: any;
        needsConfirmation: boolean;
    }>;
    detectCanaryVersions(): Promise<{
        updates: any;
        updatesVersions: any;
        needsConfirmation: boolean;
    }>;
    confirmPublish(): true | Promise<boolean>;
    prepareLicenseActions(): Promise<void>;
    prepareRegistryActions(): Promise<any>;
    updateCanaryVersions(): Promise<void[]>;
    /**
     * It is possible to override some fields in the manifest before the package is packed
     * @see https://pnpm.io/package_json#publishconfig
     * @returns
     */
    applyPublishConfigOverrides(): Promise<void[]>;
    resolveLocalDependencyLinks(): Promise<void[]>;
    resolveLocalDependencyWorkspaceProtocols(): Promise<void[]>;
    annotateGitHead(): void;
    serializeChanges(): Promise<Package[]>;
    resetChanges(): Promise<any>;
    execScript(pkg: Package, script: string): Package;
    removePackageProperties(): Promise<void[]>;
    removeTempLicensesOnError(error: any): Promise<never>;
    requestOneTimePassword(): Promise<string> | undefined;
    topoMapPackages(mapper: (pkg: Package) => Promise<any>): Promise<unknown>;
    packUpdated(): Promise<any>;
    publishPacked(): Promise<any>;
    npmUpdateAsLatest(): Promise<any>;
    getDistTag(): string | undefined;
    getPreDistTag(pkg: Package): string | undefined;
}
