import fetch from 'npm-registry-fetch';
export interface DistTagOptions extends fetch.FetchOptions {
    defaultTag?: string;
    dryRun?: boolean;
    tag: string;
}
export type KebabCase<S> = S extends `${infer C}${infer T}` ? KebabCase<T> extends infer U ? U extends string ? T extends Uncapitalize<T> ? `${Uncapitalize<C>}${U}` : `${Uncapitalize<C>}-${U}` : never : never : S;
/** LibNpmPublishOptions -  https://github.com/npm/libnpmpublish#opts */
export interface LibNpmPublishOptions extends KebabCase<fetch.FetchOptions> {
    access?: 'public' | 'restricted';
    defaultTag: string;
    dryRun?: boolean;
    strictSSL?: boolean | 'true' | 'false';
    tag?: string;
}
export interface PackagePublishConfig {
    access?: 'public' | 'restricted';
    defaultTag?: string;
    registry?: string;
    tag?: string;
}
export interface Tarball {
    name: string;
    version: string;
    files: any[];
    bundled: any[];
    filename: string;
    size: number;
    unpackedSize: number;
    shasum: string;
    integrity: boolean;
    entryCount: number;
    tarFilePath: string;
}
