"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeTempLicenses = void 0;
const tslib_1 = require("tslib");
const fs_extra_1 = tslib_1.__importDefault(require("fs-extra"));
const p_map_1 = tslib_1.__importDefault(require("p-map"));
/**
 * Remove temporary license files.
 * @param {Package[]} packagesToBeLicensed
 */
function removeTempLicenses(packagesToBeLicensed) {
    if (!packagesToBeLicensed.length) {
        return Promise.resolve();
    }
    return (0, p_map_1.default)(packagesToBeLicensed, (pkg) => fs_extra_1.default.remove(pkg.licensePath));
}
exports.removeTempLicenses = removeTempLicenses;
//# sourceMappingURL=remove-temp-licenses.js.map