"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.overridePublishConfig = void 0;
const core_1 = require("@lerna-lite/core");
// manifest fields that may make sense to overwrite
const PUBLISH_CONFIG_WHITELIST = new Set([
    'bin',
    'browser',
    'cpu',
    'esnext',
    'es2015',
    'exports',
    'imports',
    'libc',
    'main',
    'module',
    'os',
    'type',
    'types',
    'typings',
    'typesVersions',
    'umd:main',
    'unpkg',
]);
/**
 * It is possible to override some fields in the manifest before the package is published, we will use the same code as pnpm
 * @see https://github.com/pnpm/pnpm/blob/main/packages/exportable-manifest/src/overridePublishConfig.ts
 */
function overridePublishConfig(manifest) {
    const publishConfig = manifest === null || manifest === void 0 ? void 0 : manifest.publishConfig;
    if (publishConfig) {
        Object.entries(publishConfig)
            .filter(([key]) => PUBLISH_CONFIG_WHITELIST.has(key))
            .forEach(([key, value]) => {
            manifest[key] = value;
            delete publishConfig[key];
        });
        if ((0, core_1.isEmpty)(publishConfig)) {
            delete manifest.publishConfig;
        }
    }
}
exports.overridePublishConfig = overridePublishConfig;
//# sourceMappingURL=override-publish-config.js.map