import { Package } from '@lerna-lite/core';
import { OneTimePasswordCache } from '@lerna-lite/version';
import { LibNpmPublishOptions } from '../models';
/**
 * Publish a package to the configured registry.
 * @param {import("@lerna/package").Package} pkg
 * @param {string} tarFilePath
 * @param {LibNpmPublishOptions & NpmPublishOptions} [options]
 * @param {import("@lerna/otplease").OneTimePasswordCache} [otpCache]
 */
export declare function npmPublish(pkg: Package, tarFilePath: string, options?: Omit<LibNpmPublishOptions, 'defaultTag'>, otpCache?: OneTimePasswordCache): Promise<any>;
