import { OneTimePasswordCache } from '@lerna-lite/version';
import npa from 'npm-package-arg';
import fetch from 'npm-registry-fetch';
import { DistTagOptions } from '../models';
/**
 * Add a dist-tag to a package.
 * @param {string} spec
 * @param {string} [tag]
 * @param {DistTagOptions} options
 * @param {import("@lerna/otplease").OneTimePasswordCache} otpCache
 */
export declare function add(spec: string, tag: string | undefined, options: DistTagOptions, otpCache: OneTimePasswordCache): any;
/**
 * Remove a dist-tag from a package.
 * @param {string} spec
 * @param {string} tag
 * @param {DistTagOptions} options
 * @param {import("@lerna/otplease").OneTimePasswordCache} otpCache
 */
export declare function remove(spec: string, tag: string, options: DistTagOptions, otpCache: OneTimePasswordCache): any;
/**
 * List dist-tags of a package.
 * @param {string} spec
 * @param {DistTagOptions} options
 */
export declare function list(spec: string, options: DistTagOptions): any;
/**
 * Retrieve list of dist-tags for a package.
 * @param {Omit<fetch.FetchOptions, 'spec'> & { spec: npa.Result }} opts
 */
export declare function fetchTags(opts: Omit<fetch.FetchOptions, 'spec'> & {
    spec: npa.Result;
}): any;
