"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gitCheckout = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
/**
 * Reset files modified by publish steps.
 * @param {string[]} stagedFiles
 * @param {{ granularPathspec: boolean; }} gitOpts
 * @param {import("@lerna/child-process").ExecOpts} execOpts
 */
function gitCheckout(stagedFiles, gitOpts, execOpts, dryRun = false) {
    const files = (gitOpts.granularPathspec ? stagedFiles : '.');
    npmlog_1.default.silly('gitCheckout', files);
    return (0, core_1.exec)('git', ['checkout', '--'].concat(files), execOpts, dryRun);
}
exports.gitCheckout = gitCheckout;
//# sourceMappingURL=git-checkout.js.map