"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWhoAmI = void 0;
const tslib_1 = require("tslib");
const npm_registry_fetch_1 = tslib_1.__importDefault(require("npm-registry-fetch"));
const core_1 = require("@lerna-lite/core");
/**
 * Retrieve logged-in user's username via legacy API.
 * @param {import("./fetch-config").FetchConfig} opts
 * @returns {WhoIAm}
 */
async function getWhoAmI(opts) {
    opts.log.verbose('', 'Retrieving npm username');
    const data = (0, core_1.pulseTillDone)(await npm_registry_fetch_1.default.json('/-/whoami', opts));
    opts.log.silly('npm whoami', 'received %j', data);
    return data;
}
exports.getWhoAmI = getWhoAmI;
//# sourceMappingURL=get-whoami.js.map