"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getUnpublishedPackages = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const p_map_1 = tslib_1.__importDefault(require("p-map"));
const pacote_1 = tslib_1.__importDefault(require("pacote"));
/**
 * Retrieve a list of graph nodes for packages that need to be published.
 * @param {import("@lerna/package-graph").PackageGraph} packageGraph
 * @param {import("./fetch-config").FetchConfig} opts
 * @returns {Promise<import("@lerna/package-graph").PackageGraphNode[]>}
 */
function getUnpublishedPackages(packageGraph, opts) {
    npmlog_1.default.silly('getUnpublishedPackages', '');
    let chain = Promise.resolve();
    // don't bother attempting to get the packument for private packages
    // @ts-ignore
    const graphNodesToCheck = Array.from(packageGraph.values()).filter(({ pkg }) => !pkg.private);
    const mapper = (pkg) => {
        var _a;
        return pacote_1.default.packument((_a = pkg === null || pkg === void 0 ? void 0 : pkg.name) !== null && _a !== void 0 ? _a : '', opts).then((packument) => {
            if (packument.versions === undefined || packument.versions[pkg.version] === undefined) {
                return pkg;
            }
        }, () => {
            npmlog_1.default.warn('', 'Unable to determine published version, assuming %j unpublished.', pkg.name);
            return pkg;
        });
    };
    chain = chain.then(() => (0, p_map_1.default)(graphNodesToCheck, mapper, { concurrency: 4 }));
    return chain.then((results) => results.filter(Boolean));
}
exports.getUnpublishedPackages = getUnpublishedPackages;
//# sourceMappingURL=get-unpublished-packages.js.map