"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getTaggedPackages = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
/**
 * Retrieve a list of graph nodes for packages that were tagged in a non-independent release.
 * @param {import("@lerna/package-graph").PackageGraph} packageGraph
 * @param {string} rootPath
 * @param {import("@lerna/child-process").ExecOpts} execOpts
 * @returns {Promise<import("@lerna/package-graph").PackageGraphNode[]>}
 */
function getTaggedPackages(packageGraph, rootPath, execOpts, dryRun = false) {
    npmlog_1.default.silly('getTaggedPackages', '');
    // @see https://stackoverflow.com/a/424142/5707
    // FIXME: --root is only necessary for tests :P
    return (0, core_1.exec)('git', ['diff-tree', '--name-only', '--no-commit-id', '--root', '-r', '-c', 'HEAD'], execOpts, dryRun).then(({ stdout }) => {
        const manifests = stdout.split('\n').filter((fp) => path_1.default.basename(fp) === 'package.json');
        const locations = new Set(manifests.map((fp) => path_1.default.join(rootPath, path_1.default.dirname(fp))));
        // @ts-ignore
        return Array.from(packageGraph.values()).filter((node) => locations.has(node.location));
    });
}
exports.getTaggedPackages = getTaggedPackages;
//# sourceMappingURL=get-tagged-packages.js.map