"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPackagesWithoutLicense = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
/**
 * Retrieve a list of packages that lack a license file.
 * @param {Project} project
 * @param {Package[]} packagesToPublish
 * @returns {Package[]}
 */
function getPackagesWithoutLicense(project, packagesToPublish) {
    return project.getPackageLicensePaths().then((licensePaths) => {
        // this assumes any existing license is a sibling of package.json, which is pretty safe
        // it also dedupes package locations, since we don't care about duplicate license files
        const licensed = new Set(licensePaths.map((lp) => path_1.default.dirname(lp)));
        return packagesToPublish.filter((pkg) => !licensed.has(pkg.location));
    });
}
exports.getPackagesWithoutLicense = getPackagesWithoutLicense;
//# sourceMappingURL=get-packages-without-license.js.map