"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentTags = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const npm_package_arg_1 = tslib_1.__importDefault(require("npm-package-arg"));
const core_1 = require("@lerna-lite/core");
/**
 * Retrieve a list of git tags pointing to the current HEAD that match the provided pattern.
 * @param {import("@lerna/child-process").ExecOpts} execOpts
 * @param {string} matchingPattern
 * @returns {string[]}
 */
function getCurrentTags(execOpts, matchingPattern, dryRun = false) {
    npmlog_1.default.silly('getCurrentTags', 'matching %j', matchingPattern);
    const opts = Object.assign({}, execOpts, {
        // don't reject due to non-zero exit code when there are no results
        reject: false,
    });
    return (0, core_1.exec)('git', ['tag', '--sort', 'version:refname', '--points-at', 'HEAD', '--list', matchingPattern], opts, dryRun).then((result) => {
        const lines = result.stdout.split('\n').filter(Boolean);
        if (matchingPattern === '*@*') {
            // independent mode does not respect tagVersionPrefix,
            // but embeds the package name in the tag "prefix"
            return lines.map((tag) => (0, npm_package_arg_1.default)(tag).name);
        }
        // "fixed" mode can have a custom tagVersionPrefix,
        // but it doesn't really matter as it is not used to extract package names
        return lines;
    });
}
exports.getCurrentTags = getCurrentTags;
//# sourceMappingURL=get-current-tags.js.map