"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getCurrentSHA = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const core_1 = require("@lerna-lite/core");
/**
 * Retrieve current SHA from git.
 * @param {import("@lerna/child-process").ExecOpts} opts
 */
function getCurrentSHA(opts, dryRun = false) {
    npmlog_1.default.silly('getCurrentSHA', '');
    const sha = (0, core_1.execSync)('git', ['rev-parse', 'HEAD'], opts, dryRun);
    npmlog_1.default.verbose('getCurrentSHA', sha);
    return sha;
}
exports.getCurrentSHA = getCurrentSHA;
//# sourceMappingURL=get-current-sha.js.map