"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFetchConfig = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
/**
 * Create a merged options object suitable for npm-registry-fetch.
 * @param {{ [key: string]: unknown }} options
 * @param {Partial<FetchConfig>} [extra]
 * @returns {FetchConfig}
 */
function getFetchConfig(options, extra) {
    return {
        log: npmlog_1.default,
        ...options,
        ...extra,
    };
}
exports.getFetchConfig = getFetchConfig;
//# sourceMappingURL=fetch-config.js.map