"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createTempLicenses = void 0;
const tslib_1 = require("tslib");
const fs_extra_1 = tslib_1.__importDefault(require("fs-extra"));
const path_1 = tslib_1.__importDefault(require("path"));
const p_map_1 = tslib_1.__importDefault(require("p-map"));
/**
 * Create temporary license files.
 * @param {string} srcLicensePath
 * @param {Packages[]} packagesToBeLicensed
 */
function createTempLicenses(srcLicensePath, packagesToBeLicensed) {
    if (!srcLicensePath || !packagesToBeLicensed.length) {
        return Promise.resolve();
    }
    // license file might have an extension, so let's allow it
    const licenseFileName = path_1.default.basename(srcLicensePath);
    const options = {
        // make an effort to keep package contents stable over time
        preserveTimestamps: process.arch !== 'ia32',
        // (give up on 32-bit architecture to avoid fs-extra warning)
    };
    // store target path for removal later
    packagesToBeLicensed.forEach((pkg) => {
        pkg.licensePath = path_1.default.join(pkg.contents, licenseFileName);
    });
    return (0, p_map_1.default)(packagesToBeLicensed, (pkg) => fs_extra_1.default.copy(srcLicensePath, pkg.licensePath, options));
}
exports.createTempLicenses = createTempLicenses;
//# sourceMappingURL=create-temp-licenses.js.map