import npmlog from 'npmlog';
import { ProfilerConfig, TraceEvent } from './models';
export declare function generateProfileOutputPath(outputDirectory?: string): string;
/**
 * A profiler to trace execution times across multiple concurrent calls.
 */
export declare class Profiler {
    events: TraceEvent[];
    logger: typeof npmlog;
    outputPath: string;
    threads: number[];
    /**
     * @param {ProfilerConfig} options
     */
    constructor({ concurrency, log, outputDirectory }: ProfilerConfig);
    run(fn: () => void, name: string): Promise<void>;
    output(): any;
}
