"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ListCommand = exports.factory = void 0;
const core_1 = require("@lerna-lite/core");
const filter_packages_1 = require("@lerna-lite/filter-packages");
const listable_1 = require("@lerna-lite/listable");
function factory(argv) {
    return new ListCommand(argv);
}
exports.factory = factory;
class ListCommand extends core_1.Command {
    constructor(argv) {
        super(argv);
        /** command name */
        this.name = 'list';
    }
    get requiresGit() {
        return false;
    }
    async initialize() {
        this.options.isIndependent = this.project.isIndependent();
        const filteredPackages = await (0, filter_packages_1.getFilteredPackages)(this.packageGraph, this.execOpts, this.options);
        this.result = listable_1.listable.format(filteredPackages, this.options);
    }
    execute() {
        var _a, _b, _c;
        // piping to `wc -l` should not yield 1 when no packages matched
        if ((_a = this.result) === null || _a === void 0 ? void 0 : _a.text.length) {
            (0, core_1.logOutput)(this.result.text);
        }
        this.logger.success('found', '%d %s', (_b = this.result) === null || _b === void 0 ? void 0 : _b.count, ((_c = this.result) === null || _c === void 0 ? void 0 : _c.count) === 1 ? 'package' : 'packages');
    }
}
exports.ListCommand = ListCommand;
//# sourceMappingURL=list-command.js.map