"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getFilteredPackages = void 0;
const tslib_1 = require("tslib");
const core_1 = require("@lerna-lite/core");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const filter_packages_1 = require("./filter-packages");
/**
 * Retrieve a list of Package instances filtered by various options.
 * @param {import('@lerna/package-graph').PackageGraph} packageGraph
 * @param {import('@lerna/child-process').ExecOpts} execOpts
 * @param {Partial<FilterOptions>} opts
 * @returns {Promise<import('@lerna/package').Package[]>}
 */
async function getFilteredPackages(packageGraph, execOpts, opts) {
    // @ts-ignore
    const options = { log: npmlog_1.default, ...opts };
    if (options.scope) {
        options.log.notice('filter', 'including %j', options.scope);
    }
    if (options.ignore) {
        options.log.notice('filter', 'excluding %j', options.ignore);
    }
    let chain = Promise.resolve();
    chain = chain.then(() => (0, filter_packages_1.filterPackages)(packageGraph.rawPackageList, options.scope, options.ignore, options.private, options.continueIfNoMatch));
    if (options.since !== undefined) {
        options.log.notice('filter', 'changed since %j', options.since);
        if (options.excludeDependents) {
            options.log.notice('filter', 'excluding dependents');
        }
        if (options.includeMergedTags) {
            options.log.notice('filter', 'including merged tags');
        }
        chain = chain.then((filteredPackages) => Promise.resolve((0, core_1.collectUpdates)(filteredPackages, packageGraph, execOpts, opts)).then((updates) => {
            const updated = new Set(updates.map(({ pkg }) => pkg.name));
            return filteredPackages.filter((pkg) => updated.has(pkg.name));
        }));
    }
    if (options.includeDependents) {
        options.log.notice('filter', 'including dependents');
        chain = chain.then((filteredPackages) => packageGraph.addDependents(filteredPackages));
    }
    if (options.includeDependencies) {
        options.log.notice('filter', 'including dependencies');
        chain = chain.then((filteredPackages) => packageGraph.addDependencies(filteredPackages));
    }
    return chain;
}
exports.getFilteredPackages = getFilteredPackages;
//# sourceMappingURL=get-filtered-packages.js.map