"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ValidationError = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
class ValidationError extends Error {
    constructor(prefix, message, ...rest) {
        super(message);
        this.prefix = '';
        this.name = 'ValidationError';
        this.prefix = prefix;
        npmlog_1.default.resume(); // might be paused, noop otherwise
        npmlog_1.default.error(prefix, message, ...rest);
    }
}
exports.ValidationError = ValidationError;
//# sourceMappingURL=validation-error.js.map