"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.writeLogFile = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const path_1 = tslib_1.__importDefault(require("path"));
const os_1 = tslib_1.__importDefault(require("os"));
const write_file_atomic_1 = tslib_1.__importDefault(require("write-file-atomic"));
function writeLogFile(cwd) {
    let logOutput = '';
    npmlog_1.default.record.forEach((m) => {
        let pref = [m.id, m.level];
        if (m.prefix) {
            pref.push(m.prefix);
        }
        pref = pref.join(' ');
        m.message
            .trim()
            .split(/\r?\n/)
            .map((line) => `${pref} ${line}`.trim())
            .forEach((line) => {
            logOutput += line + os_1.default.EOL;
        });
    });
    // this must be synchronous because it is called before process exit
    write_file_atomic_1.default.sync(path_1.default.join(cwd, 'lerna-debug.log'), logOutput);
    // truncate log after writing
    npmlog_1.default.record.length = 0;
}
exports.writeLogFile = writeLogFile;
//# sourceMappingURL=write-log-file.js.map