"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.warnIfHanging = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
const child_process_1 = require("../child-process");
function warnIfHanging() {
    const childProcessCount = (0, child_process_1.getChildProcessCount)();
    if (childProcessCount > 0) {
        npmlog_1.default.warn('complete', `Waiting for ${childProcessCount} child ` +
            `process${childProcessCount === 1 ? '' : 'es'} to exit. ` +
            'CTRL-C to exit immediately.');
    }
}
exports.warnIfHanging = warnIfHanging;
//# sourceMappingURL=warn-if-hanging.js.map