import path from 'path';
import { Stream } from 'stream';
import url from 'url';
export declare const types: {
    access: (string | null)[];
    'allow-same-version': BooleanConstructor;
    'always-auth': BooleanConstructor;
    also: (string | null)[];
    audit: BooleanConstructor;
    'audit-level': string[];
    'auth-type': string[];
    'bin-links': BooleanConstructor;
    browser: (StringConstructor | null)[];
    ca: (ArrayConstructor | StringConstructor | null)[];
    cafile: path.PlatformPath;
    cache: path.PlatformPath;
    'cache-lock-stale': NumberConstructor;
    'cache-lock-retries': NumberConstructor;
    'cache-lock-wait': NumberConstructor;
    'cache-max': NumberConstructor;
    'cache-min': NumberConstructor;
    cert: (StringConstructor | null)[];
    cidr: (ArrayConstructor | StringConstructor | null)[];
    color: (string | BooleanConstructor)[];
    depth: NumberConstructor;
    description: BooleanConstructor;
    dev: BooleanConstructor;
    'dry-run': BooleanConstructor;
    editor: StringConstructor;
    'engine-strict': BooleanConstructor;
    force: BooleanConstructor;
    'fetch-retries': NumberConstructor;
    'fetch-retry-factor': NumberConstructor;
    'fetch-retry-mintimeout': NumberConstructor;
    'fetch-retry-maxtimeout': NumberConstructor;
    git: StringConstructor;
    'git-dry-run': BooleanConstructor;
    'git-tag-version': BooleanConstructor;
    'commit-hooks': BooleanConstructor;
    global: BooleanConstructor;
    globalconfig: path.PlatformPath;
    'global-style': BooleanConstructor;
    group: (StringConstructor | NumberConstructor)[];
    'https-proxy': (typeof url | null)[];
    'user-agent': StringConstructor;
    'ham-it-up': BooleanConstructor;
    heading: StringConstructor;
    'if-present': BooleanConstructor;
    'ignore-prepublish': BooleanConstructor;
    'ignore-scripts': BooleanConstructor;
    'init-module': path.PlatformPath;
    'init-author-name': StringConstructor;
    'init-author-email': StringConstructor;
    'init-author-url': (string | typeof url)[];
    'init-license': StringConstructor;
    'init-version': () => void;
    json: BooleanConstructor;
    key: (StringConstructor | null)[];
    'legacy-bundling': BooleanConstructor;
    link: BooleanConstructor;
    'local-address': never[];
    loglevel: string[];
    logstream: typeof Stream;
    'logs-max': NumberConstructor;
    long: BooleanConstructor;
    maxsockets: NumberConstructor;
    message: StringConstructor;
    'metrics-registry': (StringConstructor | null)[];
    'node-options': (StringConstructor | null)[];
    'node-version': ((() => void) | null)[];
    noproxy: (ArrayConstructor | StringConstructor | null)[];
    offline: BooleanConstructor;
    'onload-script': (StringConstructor | null)[];
    only: (string | null)[];
    optional: BooleanConstructor;
    'package-lock': BooleanConstructor;
    otp: (StringConstructor | null)[];
    'package-lock-only': BooleanConstructor;
    parseable: BooleanConstructor;
    'prefer-offline': BooleanConstructor;
    'prefer-online': BooleanConstructor;
    prefix: path.PlatformPath;
    preid: StringConstructor;
    production: BooleanConstructor;
    progress: BooleanConstructor;
    proxy: (boolean | typeof url | null)[];
    'read-only': BooleanConstructor;
    'rebuild-bundle': BooleanConstructor;
    registry: (typeof url | null)[];
    rollback: BooleanConstructor;
    save: BooleanConstructor;
    'save-bundle': BooleanConstructor;
    'save-dev': BooleanConstructor;
    'save-exact': BooleanConstructor;
    'save-optional': BooleanConstructor;
    'save-prefix': StringConstructor;
    'save-prod': BooleanConstructor;
    scope: StringConstructor;
    'script-shell': (StringConstructor | null)[];
    'scripts-prepend-node-path': (string | boolean)[];
    searchopts: StringConstructor;
    searchexclude: (StringConstructor | null)[];
    searchlimit: NumberConstructor;
    searchstaleness: NumberConstructor;
    'send-metrics': BooleanConstructor;
    shell: StringConstructor;
    shrinkwrap: BooleanConstructor;
    'sign-git-commit': BooleanConstructor;
    'sign-git-tag': BooleanConstructor;
    'sso-poll-frequency': NumberConstructor;
    'sso-type': (string | null)[];
    'strict-ssl': BooleanConstructor;
    tag: StringConstructor;
    timing: BooleanConstructor;
    tmp: path.PlatformPath;
    unicode: BooleanConstructor;
    'unsafe-perm': BooleanConstructor;
    'update-notifier': BooleanConstructor;
    usage: BooleanConstructor;
    user: (StringConstructor | NumberConstructor)[];
    userconfig: path.PlatformPath;
    umask: () => void;
    version: BooleanConstructor;
    'tag-version-prefix': StringConstructor;
    versions: BooleanConstructor;
    viewer: StringConstructor;
    _exit: BooleanConstructor;
};
