import { PackageGraph } from '../package-graph/package-graph';
import { QueryGraphConfig } from '../models';
import { Package } from '../package';
import { PackageGraphNode } from '../package-graph';
/**
 * A mutable PackageGraph used to query for next available packages.
 */
export declare class QueryGraph {
    graph: PackageGraph;
    cycles: Set<any>;
    /**
     * Sort a list of Packages topologically.
     *
     * @param {import("@lerna/package").Package[]} packages An array of Packages to build the list out of
     * @param {QueryGraphConfig} [options]
     *
     * @returns {import("@lerna/package").Package[]} A list of Package instances in topological order
     */
    static toposort(packages: Package[], options?: QueryGraphConfig): Package[];
    /**
     * @param {import("@lerna/package").Package[]} packages An array of Packages to build the graph out of
     * @param {QueryGraphConfig} [options]
     */
    constructor(packages: Package[], { graphType, localDependencies, rejectCycles }?: QueryGraphConfig);
    _getNextLeaf(): PackageGraphNode[];
    _getNextCycle(): any;
    getAvailablePackages(): PackageGraphNode[];
    /**
     * @param {string} name
     */
    markAsTaken(name: string): void;
    /**
     * @param {import("@lerna/package-graph").PackageGraphNode} candidateNode
     */
    markAsDone(candidateNode: PackageGraphNode): void;
}
