"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseField = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
const env_replace_1 = require("./env-replace");
const types_1 = require("./types");
// https://github.com/npm/npm/blob/latest/lib/config/core.js#L362-L407
function parseField(input, key) {
    if (typeof input !== 'string') {
        return input;
    }
    const typeList = [].concat(types_1.types[key]);
    // @ts-ignore
    const isPath = typeList.indexOf(path_1.default) !== -1;
    // @ts-ignore
    const isBool = typeList.indexOf(Boolean) !== -1;
    // @ts-ignore
    const isString = typeList.indexOf(String) !== -1;
    // @ts-ignore
    const isNumber = typeList.indexOf(Number) !== -1;
    let field = `${input}`.trim();
    if (/^'.*'$/.test(field)) {
        try {
            field = JSON.parse(field);
        }
        catch (err) {
            throw new Error(`Failed parsing JSON config key ${key}: ${field}`);
        }
    }
    if (isBool && !isString && field === '') {
        return true;
    }
    switch (field) {
        case 'true': {
            return true;
        }
        case 'false': {
            return false;
        }
        case 'null': {
            return null;
        }
        case 'undefined': {
            return undefined;
        }
        // no default
    }
    field = (0, env_replace_1.envReplace)(field);
    if (isPath) {
        const regex = process.platform === 'win32' ? /^~(\/|\\)/ : /^~\//;
        if (typeof field === 'string' && regex.test(field) && process.env.HOME) {
            field = path_1.default.resolve(process.env.HOME, field.substring(2));
        }
        field = path_1.default.resolve(field);
    }
    // eslint-disable-next-line no-restricted-globals
    if (isNumber && !isNaN(field)) {
        field = Number(field);
    }
    return field;
}
exports.parseField = parseField;
//# sourceMappingURL=parse-field.js.map