/**
 * From a dot (.) notation path, find and delete a property within an object if found given a complex object path
 * @param {Object} object - object to search from
 * @param {String} path - complex object path to find descendant property from, must be a string with dot (.) notation
 * @param {String} [sourceName] - source name of which object name to delete the field from.
 */
export declare function deleteComplexObjectProp(object: any, path: string, sourceName?: string): any;
/**
 * From a dot (.) notation path, find and return a property within an object given a complex object path
 * Note that the object path does should not include the parent itself
 * for example if we want to get `address.zip` from `user` object, we would call `getComplexObjectValue(user, 'address.zip')`
 * @param object - object to search from
 * @param path - complex object path to find descendant property from, must be a string with dot (.) notation
 * @returns outputValue - the object property value found if any
 */
export declare function getComplexObjectValue<T>(object: any, path: string): T;
/**
 * Check if an object is empty
 * @returns {Boolean}
 */
export declare function isEmpty(obj: object): boolean;
