"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toNerfDart = exports.npmConf = exports.Conf = void 0;
const tslib_1 = require("tslib");
const path_1 = tslib_1.__importDefault(require("path"));
const conf_1 = require("../utils/conf");
Object.defineProperty(exports, "Conf", { enumerable: true, get: function () { return conf_1.Conf; } });
const nerf_dart_1 = require("./nerf-dart");
Object.defineProperty(exports, "toNerfDart", { enumerable: true, get: function () { return nerf_dart_1.toNerfDart; } });
const defaults = tslib_1.__importStar(require("./defaults"));
// https://github.com/npm/npm/blob/latest/lib/config/core.js#L101-L200
function npmConf(opts) {
    const conf = new conf_1.Conf(Object.assign({}, defaults.defaults));
    // prevent keys with undefined values from obscuring defaults
    // prettier-ignore
    const cleanOpts = opts
        ? Object.keys(opts).reduce((acc, key) => {
            if (opts[key] !== undefined) {
                // eslint-disable-next-line no-param-reassign
                acc[key] = opts[key];
            }
            return acc;
        }, {})
        : {};
    conf.add(cleanOpts, 'cli');
    conf.addEnv();
    conf.loadPrefix();
    const projectConf = path_1.default.resolve(conf.localPrefix, '.npmrc');
    const userConf = conf.get('userconfig');
    /* istanbul ignore else */
    if (!conf.get('global') && projectConf !== userConf) {
        conf.addFile(projectConf, 'project');
    }
    else {
        conf.add({}, 'project');
    }
    conf.addFile(conf.get('userconfig'), 'user');
    /* istanbul ignore else */
    if (conf.get('prefix')) {
        const etc = path_1.default.resolve(conf.get('prefix'), 'etc');
        conf.root.globalconfig = path_1.default.resolve(etc, 'npmrc');
        conf.root.globalignorefile = path_1.default.resolve(etc, 'npmignore');
    }
    conf.addFile(conf.get('globalconfig'), 'global');
    conf.loadUser();
    const caFile = conf.get('cafile');
    /* istanbul ignore if */
    if (caFile) {
        conf.loadCAFile(caFile);
    }
    return conf;
}
exports.npmConf = npmConf;
//# sourceMappingURL=npm-conf.js.map