"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.logPackageError = void 0;
const tslib_1 = require("tslib");
const npmlog_1 = tslib_1.__importDefault(require("npmlog"));
/**
 * @param {import('execa').ExecaError & { pkg: import('@lerna/package').Package }} err
 * @param {boolean} stream
 */
function logPackageError(err, stream = false) {
    npmlog_1.default.error(err.command, `exited ${err.exitCode} in '${err.pkg.name}'`);
    if (stream) {
        // Streaming has already printed all stdout/stderr
        return;
    }
    if (err.stdout) {
        npmlog_1.default.error(err.command, 'stdout:');
        directLog(err.stdout);
    }
    if (err.stderr) {
        npmlog_1.default.error(err.command, 'stderr:');
        directLog(err.stderr);
    }
    // Below is just to ensure something sensible is printed after the long stream of logs
    npmlog_1.default.error(err.command, `exited ${err.exitCode} in '${err.pkg.name}'`);
}
exports.logPackageError = logPackageError;
/** @param {string} message */
function directLog(message) {
    npmlog_1.default.pause();
    console.error(message); // eslint-disable-line no-console
    npmlog_1.default.resume();
}
//# sourceMappingURL=log-package-error.js.map