"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.find = exports.findPrefix = void 0;
const tslib_1 = require("tslib");
const fs_1 = tslib_1.__importDefault(require("fs"));
const path_1 = tslib_1.__importDefault(require("path"));
// https://github.com/npm/npm/blob/876f0c8/lib/config/find-prefix.js
function findPrefix(start) {
    let dir = path_1.default.resolve(start);
    let walkedUp = false;
    while (path_1.default.basename(dir) === 'node_modules') {
        dir = path_1.default.dirname(dir);
        walkedUp = true;
    }
    if (walkedUp) {
        return dir;
    }
    return find(dir, dir);
}
exports.findPrefix = findPrefix;
function find(name, original) {
    if (name === '/' || (process.platform === 'win32' && /^[a-zA-Z]:(\\|\/)?$/.test(name))) {
        return original;
    }
    try {
        const files = fs_1.default.readdirSync(name);
        if (files.indexOf('node_modules') !== -1 || files.indexOf('package.json') !== -1) {
            return name;
        }
        const dirname = path_1.default.dirname(name);
        if (dirname === name) {
            return original;
        }
        return find(dirname, original);
    }
    catch (err) {
        if (name === original) {
            if (err.code === 'ENOENT') {
                return original;
            }
            throw err;
        }
        return original;
    }
}
exports.find = find;
//# sourceMappingURL=find-prefix.js.map