"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.envReplace = void 0;
// https://github.com/npm/npm/blob/latest/lib/config/core.js#L409-L423
function envReplace(str) {
    if (typeof str !== 'string' || !str) {
        return str;
    }
    // Replace any ${ENV} values with the appropriate environment
    const regex = /(\\*)\$\{([^}]+)\}/g;
    return str.replace(regex, (orig, esc, name) => {
        var _a;
        if (esc.length > 0 && esc.length % 2) {
            return orig;
        }
        if (!name || process.env[name] === undefined) {
            throw new Error(`Failed to replace env in config: ${orig}`);
        }
        return (_a = process.env[name]) !== null && _a !== void 0 ? _a : '';
    });
}
exports.envReplace = envReplace;
//# sourceMappingURL=env-replace.js.map